%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Some settings
[display_nb ~]      = find(cell2mat(get(S.channelProcessSelect, 'value'))==1);
chnl_num            = display_nb(get(S.channelDisplaySelect, 'Value'));
A                   = str2num(get(S.image_to_plot,'String'));
AspectRatio         = str2num(get(S.AspectRatio, 'String'));
histogram_bins      = str2num(get(S.histogram_bins,'String'));

        channel_name = get(S.channelProcessText, 'string');
        switch char(channel_name{chnl_num})                                                                                                                                                   
                case 'Height'
                    j = 1;
                case 'Height Sensor'
                    j = 2;
                case 'Deflection'
                    j = 3;
                case 'Deflection Error'
                    j = 3;
                case 'Phase'
                    j = 4;
                case 'Amplitude'
                    j = 5;
                case 'Amplitude Error'
                    j = 6;
                case 'Potential'
                    j = 7;
                case 'Peak Force Error'
                    j = 8;
                case 'DMTModulus'
                    j = 9;
                case 'LogDMTModulus'
                    j = 10;
                case 'Adhesion'
                    j = 11;
                case 'Deformation'
                    j = 12;
                case 'Dissipation'
                    j = 13;
                case 'Input1'
                    j = 14;
                case 'Input2'
                    j = 15;
        end

         min_peak_distance                          = str2double(get(S.min_peak_distance, 'string'));        
         smoothing_level                            = str2double(get(S.smoothing_level, 'string'));
         ScaleBar                                   = 1000;
         FontSize                                   = 14;  
         FontName                                   = 'Arial';                                                                                          % Font for images
         print_dpi                                  = 150;    
         amplitude_fract                            = 0.2;
         crop_fraction                              = 0.0;
         index                                      = 1;
         percent_search                             = [1 10 90 99];
         disp_percent                               = 1;
         
        if get(S.Calc_flatten_lim(j), 'value')     == 1
            min_spacing_stdev = min_spacing_stdev(1,:);
            max_spacing_stdev = max_spacing_stdev(1,:);
        else
            min_spacing_stdev                       = str2double(get(S.min_spacing_stdev_user, 'string'));
            max_spacing_stdev                       = str2double(get(S.max_spacing_stdev_user, 'string'));
        end
         
         channels_titles = ['Height [nm]          ';...
             'Height Sensor [nm]   ';...
             'Deflection [V]       ';...
             'Phase []            ';...
             'Amplitude [nm]       ';...
             'Amplitude error [nm] ';...
             'Potential [V]        ';...
             'Peak force error [nN]';...
             'DMTModulus [MPa]     ';...
             'logDMTMod [log(MPa)] ';...
             'Adhesion [nN]        ';...
             'Deformation [nm]     ';...
             'Dissipation [eV]     ';...
             'Input1 [nm]          ';...
             'Input2 [mV]          '];
        channel_info_Units = [  '[nm]   ';'[nm]   '; '[V]    '; '[]    '; '[nm]   ';...
                                '[nm]   '; '[V]    '; '[nN]   '; '[MPa]  ';...
                                'lg(MPa)'; '[nN]   '; '[nm]   '; '[eV]   ';...
                                '[nm]   '; '[mV]   '];
        
        peaks_fit                                   = get(S.peaks_fit(j), 'value')-1;
        image_to_plot                               = get(S.image_to_plot, 'string');
        
        if max(max(images(:, :, chnl_num))) == 0 && min(min(images(:, :, chnl_num))) == 0 % => the program failed at this point and the image was set to zero
            fit_hist = 0;
        else
            fit_hist = 1;
        end
    
       
%% Applies an offset to the whole image to put the reference peak at a given height reference_height
minimum_z                                                   = str2double(get(S.min_z(j), 'string'));
maximum_z                                                   = str2double(get(S.max_z(j), 'string'));
image_inside_range                                          = images(:,:,chnl_num);


            [y1_data x_data]                            = hist(reshape(image_inside_range,size(image_inside_range,1)*size(image_inside_range,2),1),min(min(image_inside_range)):(max(max(image_inside_range))-min(min(image_inside_range)))/(histogram_bins-1):max(max(image_inside_range)));
            y2_data                                     = zeros(size(y1_data,1),1);
            x_data                                      = x_data';
            y1_data                                     = y1_data';
            y1_data                                     = smooth(y1_data,smoothing_level,'loess');
            y1_data                                     = 100*y1_data/sum(y1_data);
            for i                                       = 1:size(y1_data,1)
                y2_data(i,1)                            = sum(y1_data(1:i));
            end
        
            index_low                                   = find(y2_data >= 2,1);
            percent_low                                 = x_data(index_low);
            index_high                                  = find(y2_data >= 98,1);
            percent_high                                = x_data(index_high);
            
        if (get(S.overwrite_xlim(j), 'value') == 0 && get(S.SymZLim(j), 'value') == 1)
            
            if  max(abs([percent_low,percent_high])) >= 10
                minimum_z                                    = -10*ceil(max(abs([percent_low,percent_high]))/10);
                maximum_z                                    =  10*ceil(max(abs([percent_low,percent_high]))/10);
            elseif max(abs([percent_low,percent_high])) < 10 && max(abs([percent_low,percent_high])) >= 1 
                minimum_z                                    = -1*ceil(max(abs([percent_low,percent_high])));
                maximum_z                                    =  1*ceil(max(abs([percent_low,percent_high])));
            elseif max(abs([percent_low,percent_high])) < 1 && max(abs([percent_low,percent_high])) >= 0.1
                minimum_z                                    = -0.1*ceil(max(abs([percent_low,percent_high]))*10);
                maximum_z                                    =  0.1*ceil(max(abs([percent_low,percent_high]))*10);
            elseif max(abs([percent_low,percent_high])) < 0.1
                minimum_z                                    = -0.01*ceil(max(abs([percent_low,percent_high]))*100);
                maximum_z                                    =  0.01*ceil(max(abs([percent_low,percent_high]))*100);
            end
        elseif (get(S.overwrite_xlim(j), 'value') == 0 && get(S.SymZLim(j), 'value') == 0)  || A ~= 1    
            if  max(abs([percent_low,percent_high])) >= 10
                minimum_z                                    = 10*floor(percent_low/10);
                maximum_z                                    = 10*ceil(percent_high/10);
            elseif max(abs([percent_low,percent_high])) < 10 && max(abs([percent_low,percent_high])) >= 1 
                minimum_z                                    = 1*floor(percent_low);
                maximum_z                                    = 1*ceil(percent_high);
            elseif max(abs([percent_low,percent_high])) < 1 && max(abs([percent_low,percent_high])) >= 0.1
                minimum_z                                    = 0.1*floor(percent_low*10);
                maximum_z                                    = 0.1*ceil(percent_high*10);
            elseif max(abs([percent_low,percent_high])) < 0.1
                minimum_z                                    = 0.01*floor(percent_low*100);
                maximum_z                                    = 0.01*ceil(percent_high*100);
            end 
        end

ScanZ                                                       = maximum_z-minimum_z;  

image_inside_range((image_inside_range < minimum_z))  = NaN;                                                                                                              
image_inside_range((image_inside_range > maximum_z))  = NaN; 

            [y1_data x_data]                            = hist(reshape(image_inside_range,size(image_inside_range,1)*size(image_inside_range,2),1),min(min(image_inside_range)):(max(max(image_inside_range))-min(min(image_inside_range)))/(histogram_bins-1):max(max(image_inside_range)));
            y2_data                                     = zeros(size(y1_data,1),1);
            x_data                                      = x_data';
            y1_data                                     = y1_data';
            y1_data                                     = smooth(y1_data,smoothing_level,'loess');
            y1_data                                     = 100*y1_data/sum(y1_data);
            for i                                       = 1:size(y1_data,1)
                y2_data(i,1)                            = sum(y1_data(1:i));
            end
        
            index_low                                   = find(y2_data >= 2,1);
            percent_low                                 = x_data(index_low);
            index_high                                  = find(y2_data >= 98,1);
            percent_high                                = x_data(index_high);
 height                                                      = y1_data';
position                                                    = x_data';           

%% --- Plot a nice image in GUI --- %    

    axes(S.ax1)
    if AspectRatio == 1
        imshow(imresize(images(:,:,chnl_num),[max(size(images(:,:,chnl_num))),max(size(images(:,:,chnl_num)))]),[minimum_z,maximum_z],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
    else
        imshow(imresize(images(:,:,chnl_num),[max(size(images(:,:,chnl_num)))/AspectRatio,max(size(images(:,:,chnl_num)))]),[minimum_z,maximum_z],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
    end
        color_string    = get(S.ColorBarSelect, 'string');
        color_value     = get(S.ColorBarSelect, 'value');
        switch color_string{color_value}                                                                                                                                                   
            case 'Autumn'                                                                                                                                                        
                colormap(autumn);
            case 'Bone'                                                                                                                                                        
                colormap(bone);
            case 'ColorCube'                                                                                                                                                        
                colormap(colorcube);
            case 'Cool'                                                                                                                                                        
                colormap(cool);
            case 'Copper'                                                                                                                                                        
                colormap(copper);
            case 'Flag'                                                                                                                                                        
                colormap(flag);
            case 'Gray'                                                                                                                                                        
                colormap(gray);
            case 'Hot'                                                                                                                                                        
                colormap(hot);
            case 'HSV'                                                                                                                                                        
                colormap(hsv);
            case 'Jet'                                                                                                                                                        
                colormap(jet);
            case 'Lines'                                                                                                                                                        
                colormap(lines);
            case 'Pink'                                                                                                                                                        
                colormap(pink);
            case 'Prism'                                                                                                                                                        
                colormap(prism);
            case 'Spring'                                                                                                                                                        
                colormap(spring);
            case 'Summer'                                                                                                                                                        
                colormap(summer);
            case 'Winter'                                                                                                                                                        
                colormap(winter);
            case 'Sky'
                load('Sky','mycmap_sky') 
                colormap(mycmap_sky);
        end
                                                                                                                                                            % Sets the colormap 

            hcb= colorbar('peer',S.ax1,'YTick',minimum_z:ScanZ/10:maximum_z,...
                          'YTickLabel',{            [num2str(minimum_z+0*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(minimum_z+1*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(minimum_z+2*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(minimum_z+3*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(minimum_z+4*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(minimum_z+5*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(minimum_z+6*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(minimum_z+7*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],... 
                                                    [num2str(minimum_z+8*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...  
                                                    [num2str(minimum_z+9*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(minimum_z+10*ScanZ/10,'%0.2f'),' ', channel_info_Units(j,:)]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar

disp_scale_bar      = get(S.disp_scale_bar, 'value');
if disp_scale_bar == 1
        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(images(:,:,chnl_num))),0.95*max(size(images(:,:,chnl_num)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;


        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual')
else
end
        hold off;      
%% ---Plot a nice histogram and cdf in GUI ---%
axes(S.ax2)

                [AX,H1,H2]                                  = plotyy(S.ax2,x_data,y1_data,x_data,y2_data,'plot');
                set(AX(1),'YColor','k');
                set(AX(2),'YColor','r');
                axis auto;
                
                 hold on;

                set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
                set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
                    axis_lim = [minimum_z,maximum_z];
                    set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
                    set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

                set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
                set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
                set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
                set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

                set(H1,'Color','k','LineWidth',2);
                set(H2,'Color','r','LineWidth',2);

                xlabel(channels_titles(j,:),'FontSize', FontSize, 'FontName', FontName );
                %title([channel_info(j).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
                set(AX(1),'FontSize', FontSize, 'FontName', FontName);
                set(AX(2),'FontSize', FontSize, 'FontName', FontName);

                if disp_percent == 1
                    percent_val                                     = zeros(length(percent_search),1);
                    text_disp                                       =  cell(length(percent_search),1);
                    for i                                           = 1:length(percent_search)
                        index_height                                = find(y2_data >= percent_search(i),1);
                        percent_val(i)                              = x_data(index_height);
                        text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info_Units(j,:)];
                    end
                    x_range                                         = get(AX(1),'XLim'); 
                    y_range                                         = get(AX(1),'YLim');
                    text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );
                else
                end

       if fit_hist == 1
            [gaussian_fit, gaussian_gof,n_peaks]                             = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev,max_spacing_stdev,amplitude_fract,smoothing_level);
            plot(x_data,gaussian_fit(x_data),'--b','LineWidth',2);

            for i                                           = 1:n_peaks
            text(1.05*eval(['gaussian_fit.b',num2str(i)]),...
             0.85*eval(['gaussian_fit.a',num2str(i)]),...
             { [num2str(sum(eval(['gaussian_fit.a',num2str(i),'*exp(-(x_data-gaussian_fit.b',num2str(i),').^2/((gaussian_fit.c',num2str(i),')^2))'])),'%02.2f'),'% @'];...
               [num2str(eval(['gaussian_fit.b',num2str(i)]),'%02.2f'),' +- ',num2str(eval(['1/sqrt(2)*gaussian_fit.c',num2str(i)]),'%02.2f'),' ',channel_info_Units(j,:)]},...
             'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','bottom','HorizontalAlignment','left','color','b' );
            end
            
        else
        end

            hold off; 
        
        %end
        
        
